/* $Id$
 * l2ca-regs.h: L2CA specification
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */
#ifndef _ASM_CPU_L2CA_H
#define _ASM_CPU_L2CA_H

#include <mach/hardware.h>

#define L2CID_OFFSET		0x003c0100	/* ID */
#define L2CID_REVISION		0x0000007f	/* revision */

#define L2CINFO_OFFSET		0x003c0104	/* configuration info */
#define L2CINFO_BASELINE	0x0000000f	/* baseline size */
#define L2CINFO_BASELINE_128B	0x00000003	/* - 128 byte */
#define L2CINFO_SUBLINE		0x000000f0	/* subline size */
#define L2CINFO_SUBLINE_NOSPT	0x00000000	/* - not supported */
#define L2CINFO_SUBLINE_32B	0x00000010	/* - 32 byte */
#define L2CINFO_ASSOCIATIVITY	0x00001f00	/* associativity (n+1 way) */
#define L2CINFO_WAYSIZE		0x0000e000	/* way size */
#define L2CINFO_WAYSIZE_8KB	0x0000e000	/* - 8 KB */
#define L2CINFO_WAYSIZE_16KB	0x00002000	/* - 16 KB */
#define L2CINFO_WAYSIZE_32KB	0x00004000	/* - 32 KB */
#define L2CINFO_WAYSIZE_64KB	0x00006000	/* - 64 KB */
#define L2CINFO_WAYSIZE_128KB	0x00008000	/* - 128 KB */
#define L2CINFO_WAYSIZE_256KB	0x0000a000	/* - 256 KB */

#define L2CC_OFFSET		0x000c0000	/* control */
#define L2CC_ON			0x00000001	/* on */
#define L2CC_EX			0x00002000	/* exclusive cache */
#define L2CC_WA			0x00010000	/* write allocate for WB */
#define L2CC_PRD		0x00020000	/* hardware prefecth */
#define L2CC_WTG		0x00040000	/* write gathering for WT */
#define L2CC_ACT		0x00080000	/* ID separate active way */
#define L2CC_ACT_UNIFIED	0x00000000	/* - ID unified */
#define L2CC_ACT_SEPARATE	0x00080000	/* - ID separate */
#define L2CC_BST		0x00100000	/* burst read for UCWG */

#define L2CC_MASK		0xffffffff
#define L2CC_SETTING		L2CC_ON

#define L2CLPMCR_OFFSET		0x003c0128	/* mem access ctrl LP */
#define L2CLPMCR_DS		0x00000001	/* data refill unit */
#define L2CLPMCR_DS_BASELINE	0x00000000	/* - baseline */
#define L2CLPMCR_DS_SUBLINE	0x00000001	/* - subline */
#define L2CLPMCR_IS		0x00000002	/* inst refill unit */
#define L2CLPMCR_IS_BASELINE	0x00000000	/* - baseline */
#define L2CLPMCR_IS_SUBLINE	0x00000002	/* - subline */

#define L2CMCR_OFFSET(LP)	(0x003c0b00+((LP)*4))	/* mem access ctrl */
#define L2CMCR_DS		0x00000001	/* data refill unit */
#define L2CMCR_DS_BASELINE	0x00000000	/* - baseline */
#define L2CMCR_DS_SUBLINE	0x00000001	/* - subline */
#define L2CMCR_IS		0x00000002	/* inst refill unit */
#define L2CMCR_IS_BASELINE	0x00000000	/* - baseline */
#define L2CMCR_IS_SUBLINE	0x00000002	/* - subline */

#define L2CLPDAWCR_OFFSET	0x000c0030	/* active way data LP */
#define L2CLPIAWCR_OFFSET	0x000c0034	/* active way inst LP */
#define L2CDAWCR_OFFSET(LP)	(0x000c0800+((LP)*4))	/* active way data */
#define L2CIAWCR_OFFSET(LP)	(0x000c0900+((LP)*4))	/* active way inst */

#define L2CLCKW_OFFSET		0x000c0008	/* lock way */

#define L2COPA_OFFSET		0x006c0240	/* CO primitive addr */
#define L2COPA_CM		0x00000007	/* cache command */
#define L2COPA_CM_INV		0x00000000	/* - invalidate */
#define L2COPA_CM_WB		0x00000001	/* - write back */
#define L2COPA_CM_WBINV		0x00000002	/* - write back & invalidate */
#define L2COPA_CM_PF_L2C	0x00000003	/* - prefecth to L2C */
#define L2COPA_CM_PF_PFBUF	0x00000004	/* - prefecth to pref buff */
#define L2COPA_CM_TOUCH		0x00000005	/* - touch */
#define L2COPA_CM_TOUCH_ZERO	0x00000006	/* - touch zero */
#define L2COPA_CM_TOUCH_DIRTY	0x00000007	/* - touch dirty */
#define L2COPA_TID		0x00000010	/* destination */
#define L2COPA_TID_DAWCR	0x00000000	/* - data active way (when CM=3,5,6,7) */
#define L2COPA_TID_IAWCR	0x00000010	/* - inst active way (when CM=3,5,6,7) */
#define L2COPA_TID_DPFBUF	0x00000000	/* - data pref buff (when CM=4) */
#define L2COPA_TID_IPFBUF	0x00000010	/* - inst pref buff (when CM=4) */
#define	L2COPA_ADDRESS		0xffffffe0	/* address mask */
#define	L2COPA_TID_CM		(L2COPA_TID | L2COPA_CM)	/* command mask */

#define L2COPE_OFFSET		0x006c0244	/* CO primitive entry */
#define L2COPE_CM		0x0000000f	/* cache command */
#define L2COPE_CM_INV		0x00000000	/* - invalidate */
#define L2COPE_CM_WB		0x00000001	/* - write back */
#define L2COPE_CM_WBINV		0x00000002	/* - write back & invalidate */
#define L2COPE_CM_SYNC		0x00000008	/* - sync */
#define L2COPE_CM_FLSH_PFBUF	0x00000009	/* - flush pref buff */
#define L2COPE_SL		0x00000060	/* subline mode */
#define L2COPE_ENTRY		0x07ffff80	/* entry for cache operation */
#define L2COPE_WAY		0xf8000060	/* way for cache operation */

#define L2COQM_OFFSET		0x006c0248	/* CO que mode */
#define L2COQM_CM		0x00000007	/* cache command */
#define L2COQM_CM_INV		0x00000000	/* - invalidate */
#define L2COQM_CM_WB		0x00000001	/* - write back */
#define L2COQM_CM_WBINV		0x00000002	/* - write back & invalidate */
#define L2COQM_CM_PF_L2C	0x00000003	/* - prefecth to L2C */
#define L2COQM_CM_PF_PFBUF	0x00000004	/* - prefecth to prefetch buff */
#define L2COQM_CM_TOUCH		0x00000005	/* - touch */
#define L2COQM_CM_TOUCH_ZERO	0x00000006	/* - touch zero */
#define L2COQM_CM_TOUCH_DIRTY	0x00000007	/* - touch dirty */
#define L2COQM_CW		0x00004000	/* notification mode */
#define L2COQM_CW_FLAG		0x00000000	/* - flag */
#define L2COQM_CW_FLAG_INT	0x00004000	/* - flag & interrupt */
#define L2COQM_CE		0x00008000	/* notification enable */
#define L2COQM_S		0x00060000	/* specification mode */
#define L2COQM_S_ADDRESS	0x00000000	/* - address (range/line) */
#define L2COQM_S_ALL		0x00020000	/* - all */
#define L2COQM_S_WAY		0x00040000	/* - way */
#define L2COQM_TID		0x00600000	/* destination */
#define L2COQM_TID_DAWCR	0x00000000	/* - LRU/data active way (when CM=3,5,6,7) */
#define L2COQM_TID_IAWCR	0x00200000	/* - LRU/inst active way (when CM=3,5,6,7) */
#define L2COQM_TID_WAY		0x00400000	/* - specified way (when CM=3,5,6,7) */
#define L2COQM_TID_DPFBUF	0x00000000	/* - data pref buff (when CM=4) */
#define L2COQM_TID_IPFBUF	0x00200000	/* - inst pref buff (when CM=4) */

#define L2COQAD_OFFSET		0x006c024c	/* CO que addresss */
#define L2COQSZ_OFFSET		0x006c0250	/* CO que size */
#define L2COQSZ_SIZE		0x003fffff	/* size */
#define L2COQMASK_OFFSET	0x006c0254	/* CO que mask */
#define L2COQWN_OFFSET		0x006c0258	/* CO que way num */

#define L2COPPQSEF_OFFSET	0x006c025c	/* CO que set flag PP */
#define L2COPPQSEF_OE		0x00000001	/* failure except for que full */
#define L2COPPQSEF_FE		0x00000002	/* failure for que full */

#define L2COLPQS_OFFSET		0x006c0260	/* CO que status LP */
#define L2COLPQS_QST		0x00000001	/* que status flag */
#define L2COLPQS_EST		0x00000002	/* que error flag */
#define L2COLPQS_EF		0x00000004	/* complete flag */

#define L2COQCE0_OFFSET		0x006c0270	/* CO que cmd complete flag 0 */
#define L2COQCE1_OFFSET		0x006c0274	/* CO que cmd complete flag 1 */

#define L2COQCS0_OFFSET		0x006c0278	/* CO que cmd status 0 */
#define L2COQCS1_OFFSET		0x006c027c	/* CO que cmd status 1 */

#define L2CMTAG0_OFFSET		0x000c0480	/* master tag way 0 */
#define L2CMTAG1_OFFSET		0x000c0484	/* master tag way 1 */
#define L2CMTAG2_OFFSET		0x000c0488	/* master tag way 2 */
#define L2CMTAG3_OFFSET		0x000c048c	/* master tag way 3 */
#define L2CMTAG4_OFFSET		0x000c0490	/* master tag way 4 */
#define L2CMTAG5_OFFSET		0x000c0494	/* master tag way 5 */
#define L2CMTAG6_OFFSET		0x000c0498	/* master tag way 6 */
#define L2CMTAG7_OFFSET		0x000c049c	/* master tag way 7 */
#define L2CMTAG8_OFFSET		0x000c04a0	/* master tag way 8 */
#define L2CMTAG9_OFFSET		0x000c04a4	/* master tag way 9 */
#define L2CMTAG10_OFFSET	0x000c04a8	/* master tag way 10 */
#define L2CMTAG11_OFFSET	0x000c04ac	/* master tag way 11 */
#define L2CMTAG12_OFFSET	0x000c04b0	/* master tag way 12 */
#define L2CMTAG13_OFFSET	0x000c04b4	/* master tag way 13 */
#define L2CMTAG14_OFFSET	0x000c04b8	/* master tag way 14 */
#define L2CMTAG15_OFFSET	0x000c04bc	/* master tag way 15 */
#define L2CMTAG16_OFFSET	0x000c04c0	/* master tag way 16 */
#define L2CMTAG17_OFFSET	0x000c04c4	/* master tag way 17 */
#define L2CMTAG18_OFFSET	0x000c04c8	/* master tag way 18 */
#define L2CMTAG19_OFFSET	0x000c04cc	/* master tag way 19 */
#define L2CMTAG20_OFFSET	0x000c04d0	/* master tag way 20 */
#define L2CMTAG21_OFFSET	0x000c04d4	/* master tag way 21 */
#define L2CMTAG22_OFFSET	0x000c04d8	/* master tag way 22 */
#define L2CMTAG23_OFFSET	0x000c04dc	/* master tag way 23 */
#define L2CMTAGX_V		0x00000001	/* valid */
#define L2CMTAGX_MTAG		0xfffffffe	/* mster tag */

#define SSCLUAD_OFFSET		0x000c0400	/* cache lookup */
#define SSCLUR_OFFSET		0x000c0404	/* cache lookup ersult */
#define SSCACS_OFFSET		0x000c0408	/* cache access */
#define SSCACSD_OFFSET		0x000c0408	/* cache access date */

#endif /* _ASM_CPU_L2CA_H */
